<?php defined("APP") or die() // Main Page ?>  
<section class="hero">
  <div class="container">
    <div class="row">
      <div class="col-sm-5 col-xs-12">
        <div class="promo">
          <h1><?php echo e("Congrats!") ?></h1>
          <p class="description"><?php echo e("Your <strong>domain name</strong> is now successfully pointed to our server. You can now start using it from the platform and shorten branded links with your own domain name.") ?></p>
          <p class="description"><?php echo e("If you want to display another page instead of this page when someone accesses your root domain name, you can define that link in your settings by logging in to your account. You can also define a custom 404 error page.") ?></p>
          <p class="description"><?php echo e("If you have any questions, please do not hesitate to contact us.") ?></p>
          <br>
          <p>
            <a href="<?php echo Main::href("user") ?>" class="btn btn-secondary btn-round"><?php echo e("Login to your account") ?></a>
            &nbsp;&nbsp;
            <a href="<?php echo Main::href("contact") ?>" class="btn btn-primary btn-round"><?php echo e("Contact us") ?></a>            
          </p>
        </div>        
      </div>
      <div class="col-md-offset-1 col-sm-6 hidden-xs svg">
        <svg id="ac370e99-250f-4203-ae2c-c306a69114f3" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="1144" height="697.99" viewBox="0 0 1144 697.99"><defs><linearGradient id="b5f20e7f-16f1-44c3-85ac-2c33fb8e67f8" x1="2612.03" y1="795.18" x2="2612.03" y2="399.52" gradientTransform="matrix(-1, 0, 0, 1, 3436, 0)" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="gray" stop-opacity="0.25"/><stop offset="0.54" stop-color="gray" stop-opacity="0.12"/><stop offset="1" stop-color="gray" stop-opacity="0.1"/></linearGradient></defs><title>personal settings</title><path d="M1172,516.31a180.56,180.56,0,0,1-26.12,93.88c0,34.62-16.14,66-42.32,88.87a144.74,144.74,0,0,1-21.08,15.28c-.3.19-.61.37-.92.55-.56.33-1.12.66-1.69,1l-.53.31h0A164.61,164.61,0,0,1,998.24,737H245.17q-9,0-17.84-.72a211.15,211.15,0,0,1-61.06-14.14q-5.72-2.26-11.22-4.86-2.62-1.23-5.19-2.53c-1.07-.54-2.14-1.1-3.2-1.66A187.42,187.42,0,0,1,112.2,689.7c-34-29.23-55.08-69.61-55.08-114.21A180.5,180.5,0,0,1,28,476.82c0-99.14,79.24-179.51,177-179.51,3,0,6,.09,9,.25.43,0,.85,0,1.28.06,16.48-28.09,38.51-53.9,65-76.62,72.24-61.9,177.82-100.92,295.43-100.92,98.82,0,189.15,27.55,258.34,73.07A174.18,174.18,0,0,1,920,170.6c97.74,0,177,80.37,177,179.51a184.9,184.9,0,0,1-1,18.78A180,180,0,0,1,1172,516.31Z" transform="translate(-28 -101)" fill="#001390" opacity="0.1"/><g opacity="0.2"><path d="M166.37,720.79c0,.46-.05.91-.1,1.35q-5.72-2.26-11.22-4.86a9.1,9.1,0,0,1-5.19-2.53c-1.07-.54-2.14-1.1-3.2-1.66a13.68,13.68,0,0,1,.81-1.46c2.06-3.26,5.19-5.3,8.64-5.19s6.44,2.34,8.29,5.71A16.87,16.87,0,0,1,166.37,720.79Z" transform="translate(-28 -101)" fill="#3f3d56"/><path d="M166.91,703.67a16.88,16.88,0,0,1-2.51,8.48c-2.06,3.25-5.19,5.29-8.64,5.18l-.71-.05a9.1,9.1,0,0,1-5.19-2.53,12.53,12.53,0,0,1-2.39-3.12,17.55,17.55,0,0,1,.54-17.12c2.06-3.26,5.19-5.3,8.64-5.19s6.44,2.34,8.29,5.71A16.87,16.87,0,0,1,166.91,703.67Z" transform="translate(-28 -101)" fill="#3f3d56"/><ellipse cx="156.75" cy="686.21" rx="14.01" ry="10.7" transform="translate(-562.06 720.24) rotate(-88.19)" fill="#3f3d56"/><ellipse cx="157.29" cy="669.09" rx="14.01" ry="10.7" transform="translate(-544.43 704.2) rotate(-88.19)" fill="#3f3d56"/><ellipse cx="157.83" cy="651.97" rx="14.01" ry="10.7" transform="matrix(0.03, -1, 1, 0.03, -526.79, 688.16)" fill="#3f3d56"/><path d="M121.47,533.55a49.66,49.66,0,0,1-3.8-6l28.26-3.73-30.42-.73a51.38,51.38,0,0,1,.31-40.64l40.12,22.45-36.75-28.85a51.28,51.28,0,1,1,82.84,60,51.12,51.12,0,0,1,5.55,9.53l-37.09,17.81,39.33-11.83A51.34,51.34,0,0,1,200,599.47a51.28,51.28,0,1,1-80.56-2.54,51.28,51.28,0,0,1,2-63.38Z" transform="translate(-28 -101)" fill="#001390"/><path d="M212,568.13a51.06,51.06,0,0,1-12,31.34,51.28,51.28,0,1,1-80.56-2.54C112.87,588,212.18,562.37,212,568.13Z" transform="translate(-28 -101)" opacity="0.1"/></g><path d="M986,239.41V718.59A18.41,18.41,0,0,1,967.59,737H232.41a18.13,18.13,0,0,1-5.08-.72A18.38,18.38,0,0,1,214,718.59V504.75c0-1.09,0-2.17,0-3.25V297.56c.43,0,.85,0,1.28.06,16.48-28.09,38.51-53.9,65-76.62H967.59A18.41,18.41,0,0,1,986,239.41Z" transform="translate(-28 -101)" fill="#fff"/><rect x="712.17" y="182.23" width="137.83" height="35.96" rx="17.98" fill="#3f3d56"/><rect x="721.15" y="188.24" width="119.86" height="23.93" rx="11.97" opacity="0.1"/><rect x="794.73" y="189.55" width="43.28" height="21.31" rx="10.65" fill="#001390"/><circle cx="816.04" cy="200.21" r="6.66" fill="#fff"/><rect x="712.17" y="419.28" width="137.83" height="35.96" rx="17.98" fill="#3f3d56"/><rect x="721.15" y="425.29" width="119.86" height="23.93" rx="11.97" opacity="0.1"/><rect x="794.73" y="426.6" width="43.28" height="21.31" rx="10.65" fill="#001390"/><circle cx="816.04" cy="437.26" r="6.66" fill="#fff"/><rect x="712.17" y="537.8" width="137.83" height="35.96" rx="17.98" fill="#3f3d56"/><rect x="721.15" y="543.82" width="119.86" height="23.93" rx="11.97" opacity="0.1"/><rect x="794.73" y="545.13" width="43.28" height="21.31" rx="10.65" fill="#001390"/><circle cx="816.04" cy="555.78" r="6.66" fill="#fff"/><rect x="294" y="159.59" width="80.57" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="189.55" width="223.73" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="219.52" width="223.73" height="21.31" rx="10.65" fill="#001390"/><g opacity="0.5"><rect x="294" y="278.11" width="80.57" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="308.08" width="167" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="338.04" width="223.73" height="21.31" rx="10.65" fill="#001390"/></g><rect x="294" y="396.64" width="80.57" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="426.6" width="223.73" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="456.57" width="139" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="515.16" width="80.57" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="545.13" width="223.73" height="21.31" rx="10.65" fill="#001390"/><rect x="294" y="575.09" width="180" height="21.31" rx="10.65" fill="#001390"/><line x1="260" y1="259.99" x2="912" y2="259.99" fill="none" stroke="#3f3d56" stroke-linecap="round" stroke-miterlimit="10" opacity="0.7"/><line x1="260" y1="380.49" x2="912" y2="380.49" fill="none" stroke="#3f3d56" stroke-linecap="round" stroke-miterlimit="10" opacity="0.7"/><line x1="260" y1="500.99" x2="912" y2="500.99" fill="none" stroke="#3f3d56" stroke-linecap="round" stroke-miterlimit="10" opacity="0.7"/><line x1="260" y1="624.49" x2="912" y2="624.49" fill="none" stroke="#3f3d56" stroke-linecap="round" stroke-miterlimit="10" opacity="0.7"/><ellipse cx="795" cy="687.49" rx="147.68" ry="10.5" fill="#001390" opacity="0.1"/><circle cx="70.52" cy="141.18" r="21.63" fill="#001390" opacity="0.1"/><circle cx="160.67" cy="21.63" r="21.63" fill="#001390" opacity="0.1"/><circle cx="153.34" cy="103.76" r="36.25" fill="#001390" opacity="0.1"/><rect x="712.17" y="300.75" width="137.83" height="35.96" rx="17.98" fill="#3f3d56"/><rect x="721.15" y="306.77" width="119.86" height="23.93" rx="11.97" opacity="0.1"/><path d="M753.17,762c1.57-.23,3.14-.55,4.68-.91a14.62,14.62,0,0,1-1.32,4.44c-1.53,2.9-4.52,4.65-7.27,6.43a2.25,2.25,0,0,0-2.84-.19c-3.31,2-5.95,4.82-9.46,6.54-1.23.6-2.51,1.08-3.71,1.75a20,20,0,0,0-7,7.23c-1,1.55-1.81,3.59-.83,5.13a4.44,4.44,0,0,0,1.42,1.27,8.08,8.08,0,0,0,4.87,1.45c1-.09,2-.47,3.09-.64,1.37-.24,2.77-.12,4.15-.24a24.26,24.26,0,0,0,5.84-1.51l6.87-2.4a39.68,39.68,0,0,0,5.65-2.32c1.09-.59,2.12-1.28,3.23-1.82a26,26,0,0,1,3.86-1.36l3.9-1.14a3.8,3.8,0,0,1,1.76-.23c.54.1,1,.44,1.55.58a4.68,4.68,0,0,0,2.5-.24l4.52-1.28a8.52,8.52,0,0,0,2.69-1.12c2.07-1.47,2.44-4.39,2.43-6.94A52.57,52.57,0,0,0,782.45,763a3.57,3.57,0,0,0-1.47,1.11,21.44,21.44,0,0,0-1.49-1.87,22.31,22.31,0,0,1-4.51-8.33,14.66,14.66,0,0,0,4-4.52c-2.39-9.11-4.84-18.36-9.7-26.4-1.59-2.62-3.41-5.08-5-7.66-4.73-7.5-5.7-17-11.11-24a4.16,4.16,0,0,1,0-4.88c.62-.82,1.62-1.59,1.43-2.61-.14-.73-.9-1.4-.61-2.08.14-.33.48-.51.74-.75.92-.86.8-2.31.89-3.57.2-3.18,2.09-6,3.91-8.56a5.26,5.26,0,0,1,1.44-1.56c.49-.3,1.07-.44,1.56-.74,1.72-1.09,1.6-3.62,2.42-5.5,1.08-2.48,3.8-3.73,5.58-5.74,2.27-2.56,2.85-6.12,5.24-8.35a6.13,6.13,0,0,1,.79-.64A40.24,40.24,0,0,0,775.15,658c-.23,13.53,3.13,27.53,1.56,41-1.24,10.66,5.27,21.29,14.5,26.62a69.31,69.31,0,0,0,11.29,4.79c5.78,2.07,11.54,4.2,17.21,6.58q6,2.52,11.84,5.41a147.35,147.35,0,0,1,14,7.81c5.56,3.57,11.13,7.19,15.08,12.52a11.94,11.94,0,0,0,6.66-2.45c1.52,1.2,3.36,2.11,4.79,3.44a14.46,14.46,0,0,1,3.8,7.46l-.6,0c.07,1.33.13,2.66.2,4a1.7,1.7,0,0,1-.15,1,1.81,1.81,0,0,1-.54.49l-3.08,2.09c-2.24,1.51-4.71,3.42-4.83,6.13a3.12,3.12,0,0,0,.67,2.19,4.72,4.72,0,0,0,2.74,1.24c5.36,1.13,10.85,2.23,16.28,1.5,2.58-.35,5.25-1.2,6.93-3.2,1.54-1.82,2-4.29,2.42-6.64.67-4,1.23-8.09,1.67-12.15a26.86,26.86,0,0,1,1.66-8.07,1,1,0,0,1,.43-.54c.23-.1.5,0,.74-.1s.4-.47.48-.77a47.71,47.71,0,0,0,1.43-12.08,8.14,8.14,0,0,0-.47-3.11,6.28,6.28,0,0,0-4.28-3.3,34.09,34.09,0,0,0-5.53-.66,27.46,27.46,0,0,1-4.59-.84,4.2,4.2,0,0,0-1.91-.25,1.34,1.34,0,0,0-1.16,1.33,1.71,1.71,0,0,0,.24.65l-1.56-.31c-1.26-.23-3-.78-4.89-1.24q0-.48.06-1a1.89,1.89,0,0,0-1.06-1.72l-26.42-14.12-4.94-2.64c-10.82-5.79-22-11.14-32.85-16.93-.72.22-1.32-.61-1.53-1.35s-.36-1.62-1.05-1.95c-.34-.16-.79-.15-1-.44a1.19,1.19,0,0,1-.19-.89c.35-5.27,4.12-10.13,3.37-15.35-.32-2.23-1.47-4.43-1-6.62.35-1.51,1.43-2.74,2-4.18,1.3-3.22,0-7.09,1.42-10.24a23.71,23.71,0,0,0,1.91-6.52,44.79,44.79,0,0,1,4-12.94,23.35,23.35,0,0,1,3.72-5.67c.79-.86,1.68-1.63,2.44-2.52,2.3-2.75,3.15-6.41,3.8-10,1.18-6.41,2-13.06.52-19.42-.5-2.16-1.26-4.31-1.23-6.53,0-2.66,1.07-5.71-.22-7.84a6.9,6.9,0,0,0,2.49-4.27,5.52,5.52,0,0,1,.35-1.77,5.14,5.14,0,0,1,1.67-1.5,6.91,6.91,0,0,0,2.58-6.87c1.37.62,2.81-.77,3.46-2.14s1.14-3,2.53-3.62c.94-.4,2-.16,3-.42,1.59-.41,2.56-2,3.68-3.17,2.28-2.46,5.51-3.73,8.5-5.24,8.86-4.51,16.08-11.64,23.15-18.66a78.38,78.38,0,0,0,10-11.26c.79-1.17,1.51-2.38,2.19-3.62l.18-.09.06.22c.11.44.24.88.37,1.31.32,1,.68,2.07,1,3.09,1.08,3,2.25,6.2,4.45,8.47a10.48,10.48,0,0,0,2.28,1.77,15.3,15.3,0,0,0,5.87,1.76c.78.1,1.57.16,2.36.2s1.58.07,2.36.09l16.18.43c-5.56-8.06-6-18.54-5.63-28.35.93-25.2,5.84-50.63,1.28-75.43-.55-3-1.28-6-3.11-8.41-2.4-3.15-6.34-4.67-10.18-5.56s-7.83-1.32-11.42-2.93c-3-1.37-5.76-3.57-9-4.29a19.82,19.82,0,0,0-7.2.12q-4.38.65-8.71,1.54l-.7.15H874l-.48.11-.13,0-.43.1-.16,0-.4.11-.18.05-.37.12-.21.07-.34.11-.22.09-.32.12-.24.1-.29.13-.24.12-.27.13-.24.14-.25.14-.24.16-.23.15-.24.17-.2.16-.23.2-.19.17a2.39,2.39,0,0,0-.22.23l-.17.17a3,3,0,0,0-.22.28c0,.05-.09.1-.13.16s-.18.26-.27.41l0,.06a6.09,6.09,0,0,0-.55,1.19c-.07.21-.14.42-.19.63a9.54,9.54,0,0,0-.22,1.3c0,.22,0,.45-.05.67,0,.44,0,.89,0,1.33a19.62,19.62,0,0,0,.25,2.24,24.37,24.37,0,0,0-1.16,41.23,10.94,10.94,0,0,1,.08,1.19v.26a33,33,0,0,1-.44,4.22,58.66,58.66,0,0,0-12-1.07c-2.4,0-4.82.22-7.24.41a109.13,109.13,0,0,1-7.24-9.8l-5.34-7.83a74.58,74.58,0,0,1-5-8c-1.31-2.54-2.33-5.24-3.79-7.7-3-5.07-7.9-9.38-8.51-15.25l-1.41.29c-.77-1.26-1.74-2.59-2.1-3.32a65.55,65.55,0,0,1-4.44-13c-.49-2.32-.86-4.74-2.13-6.74a15.19,15.19,0,0,0-3.11-3.3,20.57,20.57,0,0,0-6.66-4.2,8.61,8.61,0,0,0-6.81.4,10,10,0,0,0-1-.4,8.25,8.25,0,0,0-7.56.88c-2.1,1.61-3,4.37-3.32,7a17.28,17.28,0,0,0,1.78,10.62c2,3.58,5.58,6,8.54,8.84a34.59,34.59,0,0,1,5.37,6.68,73.16,73.16,0,0,1-.41,16.21c-.38,2.3-1,4.56-1.18,6.88-.73,8.38,3.63,16.76,2.07,25a6.1,6.1,0,0,0,2.83,6.47c2.24,1.21,4.86,1.37,7.32,2,4.83,1.24,9,4.33,13.88,5.48,2.25.54,4.59.64,6.83,1.24l.35.11a16.27,16.27,0,0,0-3.59,6.82c-1,4.2-.06,8.69-1.06,12.89-.82,3.46-2.88,6.48-4.91,9.41q-5.86,8.48-11.74,17a104.13,104.13,0,0,1-8.65,11.37c-5.39,5.89-14.69,10.56-17.43,17.64-.06-.17-.14-.34-.2-.51-3.88,2.85-5.33,8.16-8.42,11.85-1.51,1.79-3.37,3.24-5,4.9a56.54,56.54,0,0,0-5.53,6.87c-4.6,6.38-9.23,12.79-12.52,19.94-1.72,3.72-3.05,7.59-4.42,11.44-5.38,15.17-14.16,29.56-17.81,45.25-.89,3.83-3.22,7.29-3.57,11.21-.39,4.18,1.52,8.2,3.5,11.89,3,5.64,6.34,11.12,9,16.92,1.57,3.38,2.93,6.87,4.68,10.17,1.91,3.6,4.25,6.94,6.25,10.49C747.78,742,750.58,752.07,753.17,762Zm66.16-286.55-.48-.24A16.57,16.57,0,0,1,814,472c-4.31-4.6-6.16-11.53-7.51-17.72-.16-.74-.3-1.47-.43-2.21C811.29,459.5,816.23,467.18,819.33,475.47Z" transform="translate(-28 -101)" fill="url(#b5f20e7f-16f1-44c3-85ac-2c33fb8e67f8)"/><path d="M799.68,415.4c-.49-2.31-.85-4.71-2.12-6.69a15.16,15.16,0,0,0-3.12-3.28,20.74,20.74,0,0,0-6.68-4.17,8.34,8.34,0,0,0-7.56.87c-2.11,1.6-3,4.34-3.33,7a17.07,17.07,0,0,0,1.78,10.55c2.05,3.56,5.59,5.94,8.56,8.78a34.39,34.39,0,0,1,5.58,7,20.21,20.21,0,0,0,2.54,3.72,4.84,4.84,0,0,0,4,1.61,7,7,0,0,0,3.27-1.93c1.22-1.07,4.5-3,4.6-4.67.08-1.37-2.48-4.47-3.11-5.76A65.41,65.41,0,0,1,799.68,415.4Z" transform="translate(-28 -101)" fill="#fbbebe"/><path d="M799.68,415.4c-.49-2.31-.85-4.71-2.12-6.69a15.16,15.16,0,0,0-3.12-3.28,20.74,20.74,0,0,0-6.68-4.17,8.34,8.34,0,0,0-7.56.87c-2.11,1.6-3,4.34-3.33,7a17.07,17.07,0,0,0,1.78,10.55c2.05,3.56,5.59,5.94,8.56,8.78a34.39,34.39,0,0,1,5.58,7,20.21,20.21,0,0,0,2.54,3.72,4.84,4.84,0,0,0,4,1.61,7,7,0,0,0,3.27-1.93c1.22-1.07,4.5-3,4.6-4.67.08-1.37-2.48-4.47-3.11-5.76A65.41,65.41,0,0,1,799.68,415.4Z" transform="translate(-28 -101)" opacity="0.1"/><path d="M868.85,481.23a58.88,58.88,0,0,0-16.18-2c-9.11.13-18.49,2.34-27.17-.46A47.4,47.4,0,0,1,819,476a16.58,16.58,0,0,1-4.86-3.19c-4.32-4.57-6.18-11.46-7.52-17.6a117.44,117.44,0,0,1-2.05-18.73c-2.25,1.05-4.63,2.08-7.1,1.87s-5-2.11-5-4.59c.37,5.82.64,11.71-.33,17.45-.38,2.28-1,4.53-1.17,6.83-.74,8.33,3.63,16.65,2.07,24.86a6,6,0,0,0,2.83,6.42c2.24,1.21,4.87,1.36,7.33,2,4.83,1.23,9,4.3,13.9,5.45,2.25.53,4.6.63,6.84,1.23,3.19.85,6.1,2.68,9.36,3.25,2.44.44,5,.14,7.43.35,2.15.18,4.25.74,6.41.8,5.28.13,10.26-2.85,13.76-6.81S866.63,486,868.85,481.23Z" transform="translate(-28 -101)" fill="#f86d70"/><path d="M868.85,481.23a58.88,58.88,0,0,0-16.18-2c-9.11.13-18.49,2.34-27.17-.46A47.4,47.4,0,0,1,819,476a16.58,16.58,0,0,1-4.86-3.19c-4.32-4.57-6.18-11.46-7.52-17.6a117.44,117.44,0,0,1-2.05-18.73c-2.25,1.05-4.63,2.08-7.1,1.87s-5-2.11-5-4.59c.37,5.82.64,11.71-.33,17.45-.38,2.28-1,4.53-1.17,6.83-.74,8.33,3.63,16.65,2.07,24.86a6,6,0,0,0,2.83,6.42c2.24,1.21,4.87,1.36,7.33,2,4.83,1.23,9,4.3,13.9,5.45,2.25.53,4.6.63,6.84,1.23,3.19.85,6.1,2.68,9.36,3.25,2.44.44,5,.14,7.43.35,2.15.18,4.25.74,6.41.8,5.28.13,10.26-2.85,13.76-6.81S866.63,486,868.85,481.23Z" transform="translate(-28 -101)" opacity="0.1"/><path d="M883.31,738.67a13.69,13.69,0,0,1,4.67,1.46,11,11,0,0,1,4.06,5.48c2.18,5.38,2.63,11.3,2.73,17.11.08,4.69-.08,9.49-1.76,13.87a8.83,8.83,0,0,1-2.31,3.63,8.33,8.33,0,0,1-3.18,1.54c-2.51.69-5.41.68-7.46-.92-2.28-1.78-2.85-4.93-3.33-7.78-.65-3.84-1.57-7.93-4.43-10.58-2.12-2-5.16-3-6.7-5.42-1.84-2.91-.87-6.71.3-9.95,1-2.81,2.51-8.5,5.45-9.94S880.26,738.12,883.31,738.67Z" transform="translate(-28 -101)" fill="#fbbebe"/><path d="M775,752.47a22.15,22.15,0,0,0,4.58,8.51c1.3,1.5,2.93,3.32,2.25,5.18a4.82,4.82,0,0,1-1.23,1.65c-9.66,9.44-23.17,14-36.57,15.72a1.29,1.29,0,0,1-.65,0c-.39-.17-.49-.67-.53-1.1a13.51,13.51,0,0,1,0-4.21c.65-3.27,3.52-5.58,6.33-7.39s5.88-3.55,7.44-6.5c1.95-3.66,1.13-8.43,3.45-11.86,1.88-2.79,5.38-4,8.71-4.5,1.15-.18,3.6-1.44,4.58-.86S774.66,751.32,775,752.47Z" transform="translate(-28 -101)" fill="#fbbebe"/><path d="M884.63,738.33a1.33,1.33,0,0,1,1.16-1.32,4.35,4.35,0,0,1,1.91.24,26.5,26.5,0,0,0,4.59.85,34.07,34.07,0,0,1,5.54.65,6.27,6.27,0,0,1,4.29,3.27,8.12,8.12,0,0,1,.47,3.1,47.06,47.06,0,0,1-1.43,12c-.08.3-.2.65-.49.76s-.5,0-.73.11a.9.9,0,0,0-.43.54,26.42,26.42,0,0,0-1.67,8c-.44,4-1,8.06-1.67,12.06-.39,2.34-.88,4.8-2.42,6.6-1.69,2-4.36,2.83-6.94,3.18-5.44.72-10.93-.37-16.3-1.49a4.77,4.77,0,0,1-2.75-1.23,3.09,3.09,0,0,1-.67-2.18c.12-2.69,2.6-4.59,4.83-6.09l3.09-2.07a1.6,1.6,0,0,0,.54-.49,1.67,1.67,0,0,0,.15-1l-.2-4a11.33,11.33,0,0,1,9.87,6.14c.42.85.83,1.84,1.71,2.17a2.26,2.26,0,0,0,2.69-1.63,6.93,6.93,0,0,0-.09-3.47c-1.81-9.67-1.38-19.61-2.48-29.38a6.63,6.63,0,0,0-1-3.1C885.73,739.88,884.74,739.23,884.63,738.33Z" transform="translate(-28 -101)" fill="#f86d70"/><rect x="752.15" y="409.08" width="43.28" height="21.31" rx="10.65" transform="translate(1519.58 738.47) rotate(180)" fill="#001390"/><circle cx="746.12" cy="318.73" r="6.66" fill="#fff"/><path d="M750.11,775.82c-.45.75-1.16,1.33-1.58,2.1a1.8,1.8,0,0,0,.34,2.35,2.32,2.32,0,0,0,1.43.14,48.11,48.11,0,0,0,26-11.78,18.21,18.21,0,0,0,3.19-3.49c.85-1.29,1.57-2.87,3-3.41a51.92,51.92,0,0,1,1.34,11.45c0,2.54-.36,5.43-2.43,6.9a8.63,8.63,0,0,1-2.7,1.1l-4.52,1.28a4.81,4.81,0,0,1-2.51.24c-.53-.14-1-.48-1.55-.58a3.8,3.8,0,0,0-1.76.23l-3.91,1.14a24.86,24.86,0,0,0-3.86,1.35c-1.12.53-2.15,1.21-3.24,1.8a38.78,38.78,0,0,1-5.66,2.3l-6.87,2.39a24.91,24.91,0,0,1-5.85,1.5c-1.38.12-2.79,0-4.16.23-1,.18-2,.56-3.1.64a8.11,8.11,0,0,1-4.87-1.44,4.53,4.53,0,0,1-1.42-1.26c-1-1.53-.13-3.55.83-5.1a20.16,20.16,0,0,1,7-7.18c1.2-.66,2.49-1.14,3.72-1.74,3.51-1.7,6.16-4.54,9.47-6.48C749.57,768.67,751.58,773.4,750.11,775.82Z" transform="translate(-28 -101)" fill="#f86d70"/><path d="M846.69,498.94a28.57,28.57,0,0,0,12.16,4.73,49.5,49.5,0,0,0,6.88.37,174.85,174.85,0,0,0,28.63-2.39c-3.76-4.15-7.57-8.59-9-14a23.11,23.11,0,0,1-.44-8.77,66,66,0,0,1,2.68-11,77.63,77.63,0,0,1-12.1-.31c-2.29-.24-7.91-2.32-9.9-.74s-.46,6.67-.43,9.06a2.26,2.26,0,0,1,0,.26,28.93,28.93,0,0,1-2.31,10.58C860,493.19,853.8,498.51,846.69,498.94Z" transform="translate(-28 -101)" fill="#fbbebe"/><path d="M865.18,475.84a24.06,24.06,0,0,0,19.75,3,66,66,0,0,1,2.68-11,77.63,77.63,0,0,1-12.1-.31c-2.29-.24-7.91-2.32-9.9-.74S865.15,473.45,865.18,475.84Z" transform="translate(-28 -101)" opacity="0.1"/><circle cx="850.38" cy="353.54" r="24.11" fill="#fbbebe"/><path d="M776.09,576.53a11.23,11.23,0,0,0,5.44,9.67,21.69,21.69,0,0,0,5.9,2.08c11,2.66,22.32,4.8,33.65,4.15a18.49,18.49,0,0,0,7.14-1.5,7.66,7.66,0,0,0,4.41-5.51,5.18,5.18,0,0,1,.34-1.75,5.11,5.11,0,0,1,1.67-1.49,6.84,6.84,0,0,0,2.59-6.82c1.37.62,2.81-.77,3.46-2.13s1.15-3,2.53-3.59c.94-.4,2-.16,3-.42,1.59-.41,2.56-2,3.68-3.15,2.28-2.44,5.53-3.7,8.51-5.21,8.88-4.47,16.11-11.56,23.2-18.53a77.76,77.76,0,0,0,10-11.18,41.2,41.2,0,0,0,2.2-3.6,101.82,101.82,0,0,0,5.55-12.71c.9-2.34,1.81-4.8,1.44-7.28,0-.22-.08-.44-.13-.67a14,14,0,0,0-2.19-4.42c-2.45-3.6-5.66-7-9.88-8.12s-8.42.23-12.71,1.14a31.85,31.85,0,0,1-4.31.66c-4.54.32-9-.9-13.42-2.11l-4.78-1.32c-2.39-.66-3.59-3.55-6-4.06a8.12,8.12,0,0,0-3.25.17c-4.91.93-9.87,2.14-14.2,4.64a21.32,21.32,0,0,0-2.76,1.88,17.47,17.47,0,0,0-6.42,9.47c-1,4.17-.06,8.63-1.06,12.8-.82,3.44-2.89,6.44-4.91,9.34L803,543.83a104.13,104.13,0,0,1-8.66,11.28C788,562,776.26,567.18,776.09,576.53Z" transform="translate(-28 -101)" fill="#f86d70"/><path d="M807.53,415.4c-.49-2.31-.85-4.71-2.12-6.69a15.16,15.16,0,0,0-3.12-3.28,20.74,20.74,0,0,0-6.68-4.17,8.34,8.34,0,0,0-7.56.87c-2.11,1.6-3,4.34-3.33,7a17.07,17.07,0,0,0,1.78,10.55c2,3.56,5.59,5.94,8.56,8.78a34.39,34.39,0,0,1,5.58,7,20.21,20.21,0,0,0,2.54,3.72,4.84,4.84,0,0,0,4,1.61,7,7,0,0,0,3.27-1.93c1.22-1.07,4.5-3,4.6-4.67.08-1.37-2.48-4.47-3.11-5.76A65.41,65.41,0,0,1,807.53,415.4Z" transform="translate(-28 -101)" fill="#fbbebe"/><path d="M722.81,694.64c3,5.6,6.34,11,9.05,16.8,1.57,3.37,2.93,6.83,4.68,10.11,1.91,3.57,4.26,6.89,6.26,10.41,5,8.9,7.83,18.94,10.42,28.83a57.39,57.39,0,0,0,20.52-7.22,12.9,12.9,0,0,0,1.23-.79,14.52,14.52,0,0,0,4.14-4.57c-2.39-9-4.84-18.23-9.71-26.22-1.59-2.6-3.41-5-5-7.61-4.73-7.45-5.71-16.84-11.12-23.81a4.08,4.08,0,0,1,0-4.84c.62-.81,1.62-1.58,1.43-2.59-.14-.73-.9-1.39-.61-2.07.14-.33.48-.51.74-.75.92-.84.8-2.29.89-3.53.2-3.16,2.09-5.93,3.92-8.51a5.34,5.34,0,0,1,1.44-1.55c.49-.3,1.07-.44,1.56-.74,1.72-1.07,1.6-3.59,2.43-5.46,1.08-2.46,3.8-3.71,5.59-5.7,2.27-2.54,2.84-6.07,5.24-8.29a7.11,7.11,0,0,1,.79-.64,39.7,39.7,0,0,0-1.41,11.61c-.23,13.44,3.13,27.34,1.56,40.69-1.24,10.58,5.28,21.14,14.52,26.44a70.28,70.28,0,0,0,11.31,4.76c5.78,2.05,11.56,4.16,17.23,6.53,4,1.66,8,3.46,11.86,5.37a146,146,0,0,1,14,7.76c5.57,3.54,11.15,7.14,15.1,12.43,3.83-.1,7.34-2.4,9.76-5.37s3.93-6.56,5.34-10.11c1.23-3.07,2.45-6.22,2.54-9.53a1.9,1.9,0,0,0-1.06-1.71l-26.46-14-5-2.62c-10.83-5.75-22-11.07-32.89-16.81-.73.21-1.33-.62-1.54-1.34s-.36-1.62-1.05-1.94c-.35-.16-.79-.16-1-.44a1.2,1.2,0,0,1-.18-.88c.35-5.24,4.13-10.06,3.37-15.25-.32-2.22-1.47-4.4-1-6.57.35-1.51,1.43-2.73,2-4.16,1.29-3.2,0-7,1.42-10.17a23.34,23.34,0,0,0,1.91-6.48,43.88,43.88,0,0,1,4.05-12.84,23.18,23.18,0,0,1,3.72-5.64c.8-.85,1.69-1.62,2.44-2.5,2.31-2.73,3.15-6.37,3.81-9.88,1.18-6.37,2-13,.52-19.29-.5-2.15-1.26-4.28-1.23-6.49,0-2.91,1.31-6.32-.71-8.43a6.6,6.6,0,0,0-3-1.52,90.43,90.43,0,0,0-14.35-2.65L790.22,582a20.28,20.28,0,0,1-7.35-1.91c-3-1.65-5-4.72-6.2-7.92-3.88,2.83-5.34,8.1-8.43,11.76-1.51,1.79-3.37,3.23-5,4.87a55.11,55.11,0,0,0-5.54,6.83c-4.61,6.33-9.25,12.71-12.55,19.8-1.71,3.69-3,7.54-4.42,11.36-5.39,15.07-14.18,29.37-17.83,44.94-.9,3.81-3.23,7.24-3.58,11.14C718.91,687,720.82,691,722.81,694.64Z" transform="translate(-28 -101)" fill="#434175"/><path d="M838.53,569.54a6.85,6.85,0,0,1,.81,3.26c-.49-2.44-3.85-3.79-4.06-6.2-.1-1.11.1-1.06.79-.47C837.12,567,837.57,568.58,838.53,569.54Z" transform="translate(-28 -101)" opacity="0.1"/><path d="M828.32,576.94a5.15,5.15,0,0,1,1.53,2.26,5.75,5.75,0,0,1,.3,3.93c-.49-.23-.66-.83-.81-1.36a9.38,9.38,0,0,0-1-2.33c-.4-.63-2.23-2.13-2.21-2.82C826.1,575.58,827.83,576.57,828.32,576.94Z" transform="translate(-28 -101)" opacity="0.1"/><path d="M827.14,495.35a25.23,25.23,0,0,0,5.08,3.38c4.78,2.42,10.07,3.69,14.88,6a72.17,72.17,0,0,1,6.9,4c4.77,3,9.53,6,14.29,9.05a15.75,15.75,0,0,1,3.15,2.39c1.72,1.84,1.71,5,3.28,7a9.4,9.4,0,0,0,6.93,3.2,22.5,22.5,0,0,0,7.73-1.3,38.24,38.24,0,0,0,4.42-1.61,20.47,20.47,0,0,0,4.24-2.42,12.19,12.19,0,0,0,5-7.89,15.58,15.58,0,0,0-.85-6.44,25.11,25.11,0,0,0-1.52-3.91,15.17,15.17,0,0,0-1.22-2.05c-3.28-4.65-9.06-6.84-14.65-7.93-2.95-.57-5.95-.92-8.91-1.42a31.85,31.85,0,0,1-4.31.66c-4.54.32-9-.9-13.42-2.11l-4.78-1.32c-2.39-.66-3.59-3.55-6-4.06a8.12,8.12,0,0,0-3.25.17c-4.91.93-9.87,2.14-14.2,4.64A21.32,21.32,0,0,0,827.14,495.35Z" transform="translate(-28 -101)" opacity="0.1"/><path d="M815.49,431.36c.61,5.83,5.53,10.11,8.53,15.14,1.46,2.45,2.48,5.13,3.79,7.66a75,75,0,0,0,5,8l5.35,7.77c3.15,4.57,6.33,9.18,10.35,13,7,1.19,12.9,6.4,19.55,8.93,5.33,2,11.13,2.3,16.72,3.39s11.37,3.27,14.65,7.93a20.83,20.83,0,0,1,2.74,6,15.54,15.54,0,0,1,.85,6.43,12.19,12.19,0,0,1-5,7.9,27.71,27.71,0,0,1-8.65,4,22.74,22.74,0,0,1-7.73,1.3,9.44,9.44,0,0,1-6.94-3.2c-1.56-2-1.55-5.19-3.27-7a15.75,15.75,0,0,0-3.15-2.39l-14.29-9a72.17,72.17,0,0,0-6.9-4c-4.81-2.35-10.1-3.62-14.88-6s-9.23-6.41-10.17-11.68c-2.91-16.19-14.12-29.84-23.7-43.21.31-.06.22-.78.33-1.08a14,14,0,0,1,7-7.08C808.75,432.5,812.17,432.07,815.49,431.36Z" transform="translate(-28 -101)" fill="#f86d70"/><path d="M866,431.48a8.87,8.87,0,0,1,1-5.08c1.59-2.64,4.91-3.57,7.93-4.19s5.8-1.1,8.72-1.52a20.1,20.1,0,0,1,7.21-.13c3.26.72,6,2.91,9,4.26,3.6,1.61,7.6,2,11.44,2.92s7.79,2.39,10.2,5.52c1.83,2.37,2.56,5.4,3.11,8.35,4.57,24.63-.35,49.89-1.28,74.92-.37,9.74.07,20.15,5.64,28.16l-16.21-.43c-4.15-.11-8.61-.33-11.87-2.89-2.88-2.25-4.24-5.88-5.46-9.31a29,29,0,0,1-2.08-8.35c-.25-5.88,3.09-11.65,2-17.44-.81-4.32-4-7.82-7.32-10.65s-7.1-5.3-9.83-8.75c-4.85-6.15-5.78-14.54-5.18-22.35.36-4.64,1.2-9.29.79-13.93a17.53,17.53,0,0,0-3.67-9.76C867.59,437.75,866.24,435.83,866,431.48Z" transform="translate(-28 -101)" fill="#434175"/><path d="M867,426.4c1.56-2.6,4.8-3.54,7.77-4.15a7.67,7.67,0,0,0-3.85,3,9,9,0,0,0-1,5.09c.22,4.35,1.57,6.27,4.15,9.35a17.44,17.44,0,0,1,3.68,9.76c.4,4.64-.43,9.28-.79,13.93-.61,7.8.32,16.2,5.18,22.35,2.72,3.45,6.47,5.91,9.83,8.75s6.51,6.33,7.32,10.65c1.08,5.78-2.26,11.56-2,17.44a28.51,28.51,0,0,0,2.07,8.34c1.23,3.44,2.59,7.07,5.46,9.32,3.26,2.56,7.73,2.78,11.88,2.89l11.48.3c.25.42.52.84.8,1.25l-16.21-.43c-4.15-.11-8.61-.33-11.87-2.89-2.88-2.25-4.24-5.88-5.46-9.31a29,29,0,0,1-2.08-8.35c-.25-5.88,3.09-11.65,2-17.44-.81-4.32-4-7.82-7.32-10.65s-7.1-5.3-9.83-8.75c-4.85-6.15-5.78-14.54-5.18-22.35.36-4.64,1.2-9.29.79-13.93a17.53,17.53,0,0,0-3.67-9.76c-2.58-3.08-3.93-5-4.16-9.35A8.87,8.87,0,0,1,867,426.4Z" transform="translate(-28 -101)" opacity="0.1"/><path d="M745.22,680.23,775,752.78a14.52,14.52,0,0,0,4.14-4.57c-2.39-9-4.84-18.23-9.71-26.22-1.59-2.6-3.41-5-5-7.61-4.73-7.45-5.71-16.84-11.12-23.81a4.08,4.08,0,0,1,0-4.84c.62-.81,1.62-1.58,1.43-2.59-.14-.73-.9-1.39-.61-2.07.14-.33.48-.51.74-.75.92-.84.8-2.29.89-3.53.2-3.16,2.09-5.93,3.92-8.51a5.34,5.34,0,0,1,1.44-1.55c.49-.3,1.07-.44,1.56-.74,1.72-1.07,1.6-3.59,2.43-5.46,1.08-2.46,3.8-3.71,5.59-5.7,2.27-2.54,2.84-6.07,5.24-8.29l.21-.52-2.25-14Z" transform="translate(-28 -101)" opacity="0.1"/><ellipse cx="977.05" cy="659.35" rx="33.95" ry="6.53" fill="#001390"/><ellipse cx="977.62" cy="656.57" rx="3.95" ry="5.17" fill="#3f3d56"/><ellipse cx="977.62" cy="650.25" rx="3.95" ry="5.17" fill="#3f3d56"/><ellipse cx="977.62" cy="643.92" rx="3.95" ry="5.17" fill="#3f3d56"/><ellipse cx="977.62" cy="637.6" rx="3.95" ry="5.17" fill="#3f3d56"/><ellipse cx="977.62" cy="631.27" rx="3.95" ry="5.17" fill="#3f3d56"/><ellipse cx="977.62" cy="624.95" rx="3.95" ry="5.17" fill="#3f3d56"/><ellipse cx="977.62" cy="618.63" rx="3.95" ry="5.17" fill="#3f3d56"/><path d="M990.82,676.35a18.78,18.78,0,0,1-1.47-2.17l10.38-1.71-11.23.09a19,19,0,0,1-.36-15l15.07,7.81-13.9-10.21a18.94,18.94,0,1,1,31.27,21.19,18.34,18.34,0,0,1,2.16,3.45l-13.48,7,14.38-4.82a19.07,19.07,0,0,1,1,6.07,18.85,18.85,0,0,1-4.06,11.71,18.93,18.93,0,1,1-29.76,0,18.94,18.94,0,0,1,0-23.41Z" transform="translate(-28 -101)" fill="#001390"/><path d="M1024.64,688.05a18.85,18.85,0,0,1-4.06,11.71,18.93,18.93,0,1,1-29.76,0C988.28,696.54,1024.64,685.93,1024.64,688.05Z" transform="translate(-28 -101)" opacity="0.1"/><ellipse cx="1043.17" cy="586.83" rx="22.83" ry="4.39" fill="#001390"/><ellipse cx="1043.56" cy="584.97" rx="2.66" ry="3.48" fill="#3f3d56"/><ellipse cx="1043.56" cy="580.72" rx="2.66" ry="3.48" fill="#3f3d56"/><ellipse cx="1043.56" cy="576.46" rx="2.66" ry="3.48" fill="#3f3d56"/><ellipse cx="1043.56" cy="572.21" rx="2.66" ry="3.48" fill="#3f3d56"/><ellipse cx="1043.56" cy="567.96" rx="2.66" ry="3.48" fill="#3f3d56"/><ellipse cx="1043.56" cy="563.71" rx="2.66" ry="3.48" fill="#3f3d56"/><ellipse cx="1043.56" cy="559.45" rx="2.66" ry="3.48" fill="#3f3d56"/><path d="M1061.61,631.36a11,11,0,0,1-1-1.46l7-1.15-7.55.06a12.62,12.62,0,0,1-1.17-5.32,12.78,12.78,0,0,1,.92-4.77l10.14,5.26-9.35-6.87a12.73,12.73,0,1,1,21,14.25,12.56,12.56,0,0,1,1.45,2.32l-9.06,4.71,9.66-3.25a12.77,12.77,0,0,1-2.05,12,12.74,12.74,0,1,1-20,0,12.71,12.71,0,0,1,0-15.74Z" transform="translate(-28 -101)" fill="#001390"/><path d="M1084.34,639.23a12.72,12.72,0,0,1-2.72,7.87,12.74,12.74,0,1,1-20,0C1059.9,644.93,1084.34,637.8,1084.34,639.23Z" transform="translate(-28 -101)" opacity="0.1"/></svg>
      </div>
    </div>
  </div>   
</section>